﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using IndianHealthService.BMXNet.WinForm.Configuration;
using IndianHealthService.BMXNet.WinForm.Forms;

namespace IndianHealthService.BMXNet.WinForm.Forms
{
    internal partial class RpmsServerConnectionPropertiesDialog : Form
    {
        public RpmsServerConnectionPropertiesDialog()
        {
            InitializeComponent();
        }

        private void entry_TextChanged(object sender, EventArgs e)
        {
            this.UpdateCues();
        }

        private void UpdateCues()
        {
            this.okButton.Enabled = this.ValidateInput();
            this.testButton.Enabled = this.okButton.Enabled;
        }

        private void txtNamespace_TextChanged(object sender, EventArgs e)
        {
            this.useDefaultNameSpaceCheck.Checked = this.txtNamespace.Text.Length == 0;
        }

        private void useDefaultNameSpaceCheck_CheckedChanged(object sender, EventArgs e)
        {
            if (this.useDefaultNameSpaceCheck.Checked)
            {
                this.txtNamespace.Text = "";
            }
        }

        private void RpmsServerConnectionPropertiesDialog_Load(object sender, EventArgs e)
        {
            this.Icon = this.Owner==null ? null : this.Owner.Icon;
            
            this.connectionNameEntry.Text = this.Model.Name;
            this.serverEntry.Text = this.Model.Server;
            this.portEntry.Text=this.Model.Port.ToString();
            this.txtNamespace.Text = this.Model.NameSpace;
            this.defaultConnectionCheckbox.Checked = this.Model.IsDefault;
            this.useWindowsCheckbox.Checked = this.Model.UseWindowsAuthentication;
            this.useDefaultNameSpaceCheck.Checked = this.Model.UseDefaultNamespace;

            this.UpdateCues();
        }

        public bool ValidateInput()
        {
            int port = 0;

           return
               (this.connectionNameEntry.Text.Length > 0)
               &&
               (this.serverEntry.Text.Length > 0 )
               &&
               (int.TryParse(this.portEntry.Text,out port));

        }

        private RpmsConnectionSpec _model = null;

        public RpmsConnectionSpec Model
        {
            get { return _model; }
            set { _model = value; }
        }

        private void okButton_Click(object sender, EventArgs e)
        {
            if (this.ValidateInput())
            {

                this.Model.Name = this.connectionNameEntry.Text.Trim();
                this.Model.Server = this.serverEntry.Text.Trim();
                this.Model.Port = int.Parse(this.portEntry.Text.Trim());
                this.Model.NameSpace = this.txtNamespace.Text.Trim();
                this.Model.IsDefault = this.defaultConnectionCheckbox.Checked;
                this.Model.UseWindowsAuthentication = this.useWindowsCheckbox.Checked;
                this.Model.UseDefaultNamespace = this.useDefaultNameSpaceCheck.Checked;

                this.Close();
            }
        }

        

        private void cancelButton_Click(object sender, EventArgs e)
        {
            this.Model = null;
            this.Close();
        }

        private void testButton_Click(object sender, EventArgs e)
        {
            ConnectionTest test = new ConnectionTest();
            test.UiOwner = this;

            RpmsConnectionSpec testSpec = new RpmsConnectionSpec();
            testSpec.Name = this.connectionNameEntry.Text.Trim();
            testSpec.Server = this.serverEntry.Text.Trim();
            testSpec.Port = int.Parse(this.portEntry.Text.Trim());
            testSpec.NameSpace = this.txtNamespace.Text.Trim();
            testSpec.IsDefault = true; //This is so auth will work
            testSpec.UseWindowsAuthentication = this.useWindowsCheckbox.Checked;               

            test.Test(testSpec);
        }

   
    }
}
